; // final detail depends on scale (m) and number of iterations
; // should be yRes^(1/iters), or (yRes / 1.5)^(1/iters) for diagonal lines
;
; // speed depends on number of iterations: .1*iTime is nice for 32 iters
;
; void mainImage( out vec4 o, vec2 u ) {
;   float t = .1*iTime;
;   vec3 m = 1.14 * vec3(cos(t), sin(t), -sin(t));
;   vec2 p = 1. + vec2(sin(t*1.618), sin(t*log(10.)));
;   vec2 q = vec2(0); //p //.2 * vec2(sin(t*.1*log(7.)), sin(t*.1*sqrt(2.)));
;   o.xyz = iResolution;
; //  u = (u+u-o.xy)/o.y + p;
;   u = (u+u-o.xy)/o.y;
;   u = floor(100. * u) / 100.;
;   // 100^(1/16) = 1.333
;   // 100^(1/24) = 1.211
;   // 100^(1/32) = 1.154
;   for(int i=0; i<32; i++) {
;       u = (abs(u) - p) * mat2(m.xzyx);
;   }
;   u = clamp(abs(u),0.,2.);
; //  u = floor(8. * u) / 8.;
;   o = sqrt(vec4(u.y, .5 * (u.x+u.y), u.x, 0)) - .25;
; //  o = vec4(u.y, .5 * (u.x+u.y), u.x, 0);
; }


;vec2 sq(vec2 x) { return x*x; }
;
;void mainImage( out vec4 o, vec2 u ) {
;  float t = .05*iTime;
;  float T = t*3.141592653589;
;  vec3 m = 1.14 * vec3(cos(T), sin(T), -sin(T));
;  vec2 p = sq(vec2(sin(t), sin(t*1.4426950408)));
;  o.xyz = iResolution;
;//  u = (u+u-o.xy)/o.y + p;
;  u = (u+u-o.xy)/o.x;
;  u = floor(100. * u) / 100.;
;  // 100^(1/16) = 1.333
;  // 100^(1/24) = 1.211
;  // 100^(1/32) = 1.154
;  for(int i=0; i<32; i++) {
;      u = (abs(u) - p) * mat2(m.xzyx);
;  }
;  u = clamp(abs(u) * 4.,0.,2.);
;//  u = floor(8. * u) / 8.;
;  o = sqrt(vec4(u.y, .5 * (u.x+u.y), u.x, 0)) - .25;
;//  o = vec4(u.y, .5 * (u.x+u.y), u.x, 0);
;}



org 100h ; assume ax=0 bx=0 si=0x100 di=-2

TIME:
  cwd           ;99     dx=0
  add al,0x13   ;04 13  graphics mode 320x200
  inc di        ;47     t = float[0x100] = 37636.6, eps = 1/256 = 2^(15-23)

; Set 320x200 mode and two-channel palette (4 bits orange * 4 bits blue)
ZOOM:
P int 0x10      ;CD 10  on init: set graphics mode, later: set palette
  xchg ax,cx    ;91     <- can be 90 "nop" (for zoom = 1.1255)
  aas           ;3F     zoom = float[0x104] = 1.1333

  mov bp,dx     ; bp=4 after loop
  dec bx        ; next index: 255..1 (0 stays black)
  dec dx
  mov ax,0x1010 ; set palette: bl=index dh=red ch=green cl=blue
  and dx,0x3c3c ; dx: ..RRRR.. ..BBBB.. (easier when decrementing dx)
  mov cx,dx     ; ch=R cl=B
  add ch,cl
  shr cx,1      ; ch=green=(R+B)/2 cl=blue=B/2
  jnz P
                ; cx=dx=0 bx=0xff00 bp=4 di=-1 ax=0x1010
  mov bh,0xa0
  mov es,bx     ; es = screen segment

; Frame loop: advance time and prepare coefficients.
M inc dword[si]    ; t += 1/256, double speed every 2^23 frames

  ; Scale * rotation: zoom * cos(t), zoom * sin(t)
  fld dword[si]
  fsincos          ; c=cos(t) s=sin(t)
  fdiv st1,st0     ; c s/c, assume c is never 0
  fmul dword[bp+si]; c=c*zoom s/c

  ; Translation: t * sin([U*t, V*t])^2
  fldln2
  fldlg2           ; U=0.301 V=0.693 c s/c
U fmul dword[si]   ; U*t              ; V*t
  fsin             ; sin(U*t)         ; sin(V*t)
  fmul st0         ; u=t*sin(U*t)^2   ; v=t*sin(V*t)^2
  fmul dword[si]
  fxch st2         ; c*zoom V u s/c   ; s/c u v
  fstp dword[bx]   ; [bx]=c*zoom      ; [bx+4]=s/c
  xor bx,bp
  jpo U  ; loop 2x ; u v

; Pixel loop.
L mov ax,0xcccd  ; convert width=320 to width=65536 (-32768..32767)
  mul di     ; X=0 on the left/right edge of the screen
  add dx,bx  ; center Y
  push dx
  push ax    ; store [-4]=dx=y, [-5]=dl:ah=x
  fild word[bp-4-4] ; y u v
  fild word[bp-4-5] ; x y u v

  xor ax,ax         ; al=loop counter, ah=0

; KIFS iteration: x, y <- zoom * rotate2D(|x|-u, |y|-v).
I fld st1           ; y x _ u v         ; x sy _ cy u v
  fabs
  fsub st4          ; y=|y|-v x _ u v   ; x=|x|-u sy _ cy u v
  fmul dword[bx]    ; cy x _ u v        ; cx sy _ cy u v
  fst st2           ; cy x cy u v       ; cx sy cx cy u v
  fmul dword[bx+4]  ; sy x cy u v       ; sx sy cx cy u v
  add al,0x82       ; cycle: 00 82 04 86 08 8a ... 7c fe [80]
  jnc I  ; loop 2x  ;           nc c  nc c  nc ... c  nc  c
  faddp st3,st0     ; sy cx cy+sx u v
  fsubp st1,st0     ; x=cx-sy y=cy+sx u v
  jns I  ; loop 32x ; ax=0x80

;I fabs              ; |x| y u v        ; |y| cx sx u v
;  fadd st3          ; x=|x|+v y u v    ; y=|y|+u cx sx u v
;  fmul dword[bx]    ; cx y u v         ; cy cx sx u v
;  fld st0           ; cx cx y u v      ; cy cy cx sx u v
;  fmul dword[bx+4]  ; sx cx y u v      ; sy cy cx sx u v
;  fxch st2          ; y cx sx u v      ; cx cy sy sx u v
;  add al,0x82
;  jnc I
;  fsubrp st2,st0    ; cy cx-sy sx u v
;  faddp st2,st0     ; x=cx-sy y=cy+sx u v
;  jns I

; Draw pixel: combine orange and blue channel
                    ; ax=0x80
S fabs              ; [bx+si]=|x|       ; [bx+si]=|y|
  fistp word[bx+si] ; if it's > 0x7fff, store 0x8000
  imul dx,[bx+si],2 ; double, set carry if it was > 0x3fff
  sbb dh,bl         ; dh -= carry (0xff on overflow)
  shld ax,dx,4      ; accumulate color in al, set sign flag
  pop dx            ; also clean up the stack
  jns S  ; loop 2x
  stosb             ; draw pixel

  loop L ; loop 65536x

  fcompp            ; drop u, v

;esc?
;  in al,0x60
;  cmp al,1
;  jne M
;  ret

  jmp M
